<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="js">
<head>
    <meta charset="utf-8">
    <meta name="author" content="Softnio">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="site-token" content="{{ site_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>{{ __(config('app.system').' Activation') }}</title>
    <link rel="shortcut icon" href="{{ asset('favicon.ico') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/apps.css') }}">
</head>
<body class="nk-body npc-cryptlite">
<div class="nk-app-root">
    <div class="nk-wrap">
        <div class="nk-content my-auto">
            <div class="nk-block wide-md mx-auto">
                <div class="brand-logo pb-4 text-center">
                    <span class="logo-link">
                        @if (config('app.pid') == '23604094')
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 590 160" class="logo-light logo-img" x="0px" y="0px" xml:space="preserve" height="40"><path d="m134.5 36.8-57.5-33.3c-3.5-2-7.8-2-11.3 0l-57.4 33.3c-3.5 2-5.6 5.8-5.6 9.8v66.7c0 4.1 2.2 7.8 5.6 9.8l57.4 33.3c1.7 1 3.7 1.5 5.6 1.5s3.9-0.5 5.6-1.5l57.4-33.3c3.5-2 5.6-5.8 5.6-9.8v-66.6c0.2-4.1-1.9-7.8-5.4-9.9zm-4.1 9.8v54.5h-24.5l10.8-63.6 12.7 7.4c0.6 0.4 1 1 1 1.7zm-35.9 62.3h35.8v4.4c0 0.2 0 0.3-0.1 0.5h-41l0.8-4.4 13.3-79.6 4 2.3-12.8 76.8zm-83.1 4.5v-56.4h32.9l-12.3 69.5-19.7-11.4c-0.5-0.4-0.9-1-0.9-1.7zm60.5 35.1c-0.6 0.3-1.3 0.3-1.9 0l-16.4-9.5 14.4-82h21.7l1.4-7.8h-32.1l-14.7 84.4-4.1-2.4 14.3-82.1h-43.1v-2.6c0-0.7 0.4-1.3 1-1.7l1.1-0.7h78.3l1.3-7.8h-66.1l42.9-24.9c0.3-0.2 0.6-0.3 1-0.3 0.3 0 0.7 0.1 1 0.3l23.3 13.5-16.4 96.6h39.2l-46.1 27z" fill="#7d70fc"></path><path d="m167.4 62.9v-10h44.5v10h-16.3v44.3h-11.9v-44.3h-16.3zm52.1 6.1c1.2-3.5 3-6.5 5.2-9.1 2.3-2.6 5.1-4.6 8.4-6.1s7.1-2.2 11.2-2.2c4.2 0 8 0.7 11.3 2.2s6.1 3.5 8.4 6.1 4 5.6 5.2 9.1 1.8 7.2 1.8 11.3c0 4-0.6 7.6-1.8 11.1-1.2 3.4-3 6.4-5.2 8.9-2.3 2.5-5.1 4.5-8.4 6-3.3 1.4-7 2.2-11.3 2.2-4.2 0-7.9-0.7-11.2-2.2-3.3-1.4-6.1-3.4-8.4-6-2.3-2.5-4-5.5-5.2-8.9s-1.8-7.1-1.8-11.1c0-4.1 0.6-7.9 1.8-11.3zm10.9 17.9c0.5 2.2 1.4 4.1 2.5 5.8 1.2 1.7 2.7 3.1 4.6 4.1s4.2 1.6 6.8 1.6c2.7 0 5-0.5 6.8-1.6 1.9-1 3.4-2.4 4.6-4.1s2-3.7 2.5-5.8c0.5-2.2 0.8-4.4 0.8-6.7 0-2.4-0.3-4.7-0.8-6.9s-1.4-4.2-2.5-6c-1.2-1.7-2.7-3.1-4.6-4.2-1.9-1-4.2-1.6-6.8-1.6-2.7 0-5 0.5-6.8 1.6-1.9 1-3.4 2.4-4.6 4.2-1.2 1.7-2 3.7-2.5 6-0.5 2.2-0.8 4.5-0.8 6.9 0 2.3 0.3 4.6 0.8 6.7zm62.7-34v22.5l21.2-22.5h14.9l-21.2 21.4 23.3 32.9h-15l-16.4-24.4-6.8 6.9v17.5h-11.9v-54.3h11.9zm47 21.7h29.3v9.3h-29.3v-9.3zm0-21.7h29.3v10h-29.3v-10zm0 44.2h29.3v10h-29.3v-10zm51.1-44.2 22.7 36.4h0.2v-36.4h11.2v54.3h-11.9l-22.6-36.4h-0.2v36.4h-11.2v-54.3h11.8z" fill="#fff"></path><path d="m445.5 52.9v48.2h28.7v6.1h-36v-54.3h7.3zm44.5 0v54.3h-7.2v-54.3h7.2zm8.3 6.1v-6.1h43.4v6.1h-18.1v48.2h-7.2v-48.2h-18.1zm88.8-6.1v6.1h-30.3v17.3h28.2v6.1h-28.2v18.8h30.5v6.1h-37.7v-54.4h37.5z" fill="#e1e1eb"></path></svg>
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 590 160" class="logo-dark logo-img" x="0px" y="0px" xml:space="preserve" height="40"><path d="m134.5 36.8-57.5-33.3c-3.5-2-7.8-2-11.3 0l-57.4 33.3c-3.5 2-5.6 5.8-5.6 9.8v66.7c0 4.1 2.2 7.8 5.6 9.8l57.4 33.3c1.7 1 3.7 1.5 5.6 1.5s3.9-0.5 5.6-1.5l57.4-33.3c3.5-2 5.6-5.8 5.6-9.8v-66.6c0.2-4.1-1.9-7.8-5.4-9.9zm-4.1 9.8v54.5h-24.5l10.8-63.6 12.7 7.4c0.6 0.4 1 1 1 1.7zm-35.9 62.3h35.8v4.4c0 0.2 0 0.3-0.1 0.5h-41l0.8-4.4 13.3-79.6 4 2.3-12.8 76.8zm-83.1 4.5v-56.4h32.9l-12.3 69.5-19.7-11.4c-0.5-0.4-0.9-1-0.9-1.7zm60.5 35.1c-0.6 0.3-1.3 0.3-1.9 0l-16.4-9.5 14.4-82h21.7l1.4-7.8h-32.1l-14.7 84.4-4.1-2.4 14.3-82.1h-43.1v-2.6c0-0.7 0.4-1.3 1-1.7l1.1-0.7h78.3l1.3-7.8h-66.1l42.9-24.9c0.3-0.2 0.6-0.3 1-0.3 0.3 0 0.7 0.1 1 0.3l23.3 13.5-16.4 96.6h39.2l-46.1 27z" fill="#7D70FC"></path><path d="m167.4 62.9v-10h44.5v10h-16.3v44.3h-11.9v-44.3h-16.3zm52.1 6.1c1.2-3.5 3-6.5 5.2-9.1 2.3-2.6 5.1-4.6 8.4-6.1s7.1-2.2 11.2-2.2c4.2 0 8 0.7 11.3 2.2s6.1 3.5 8.4 6.1 4 5.6 5.2 9.1 1.8 7.2 1.8 11.3c0 4-0.6 7.6-1.8 11.1-1.2 3.4-3 6.4-5.2 8.9-2.3 2.5-5.1 4.5-8.4 6-3.3 1.4-7 2.2-11.3 2.2-4.2 0-7.9-0.7-11.2-2.2-3.3-1.4-6.1-3.4-8.4-6-2.3-2.5-4-5.5-5.2-8.9s-1.8-7.1-1.8-11.1c0-4.1 0.6-7.9 1.8-11.3zm10.9 17.9c0.5 2.2 1.4 4.1 2.5 5.8 1.2 1.7 2.7 3.1 4.6 4.1s4.2 1.6 6.8 1.6c2.7 0 5-0.5 6.8-1.6 1.9-1 3.4-2.4 4.6-4.1s2-3.7 2.5-5.8c0.5-2.2 0.8-4.4 0.8-6.7 0-2.4-0.3-4.7-0.8-6.9s-1.4-4.2-2.5-6c-1.2-1.7-2.7-3.1-4.6-4.2-1.9-1-4.2-1.6-6.8-1.6-2.7 0-5 0.5-6.8 1.6-1.9 1-3.4 2.4-4.6 4.2-1.2 1.7-2 3.7-2.5 6-0.5 2.2-0.8 4.5-0.8 6.9 0 2.3 0.3 4.6 0.8 6.7zm62.7-34v22.5l21.2-22.5h14.9l-21.2 21.4 23.3 32.9h-15l-16.4-24.4-6.8 6.9v17.5h-11.9v-54.3h11.9zm47 21.7h29.3v9.3h-29.3v-9.3zm0-21.7h29.3v10h-29.3v-10zm0 44.2h29.3v10h-29.3v-10zm51.1-44.2 22.7 36.4h0.2v-36.4h11.2v54.3h-11.9l-22.6-36.4h-0.2v36.4h-11.2v-54.3h11.8z" fill="#242650"></path><path d="m445.5 52.9v48.2h28.7v6.1h-36v-54.3h7.3zm44.5 0v54.3h-7.2v-54.3h7.2zm8.3 6.1v-6.1h43.4v6.1h-18.1v48.2h-7.2v-48.2h-18.1zm88.8-6.1v6.1h-30.3v17.3h28.2v6.1h-28.2v18.8h30.5v6.1h-37.7v-54.4h37.5z" fill="#7e7f91"></path></svg>
                        @else
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 280 43" class="logo-light logo-img" height="28"><path d="M10.255,1.168V42.629H0V1.168Z" transform="translate(0 -0.399)" fill="#fff"/><polygon points="38.861 0.79 38.861 26.476 23.508 0.77 13.073 0.77 13.073 42.231 23.148 42.231 23.148 16.821 38.741 42.231 48.936 42.231 48.936 28.13 38.861 0.79" fill="#fff"/><path d="M197.481,37.268Q191.772,43.4,182.649,43.4t-14.831-6.131q-5.709-6.129-5.709-15.429a21.6,21.6,0,0,1,5.709-15.31Q173.527.4,182.649.4t14.832,6.13a21.6,21.6,0,0,1,5.709,15.31Q203.19,31.139,197.481,37.268Zm-7.22-23.987a10.208,10.208,0,0,0-15.223,0,12.56,12.56,0,0,0-2.967,8.558,12.729,12.729,0,0,0,2.967,8.677,10.208,10.208,0,0,0,15.223,0,12.734,12.734,0,0,0,2.967-8.677A12.565,12.565,0,0,0,190.261,13.281Z" transform="translate(0 -0.399)" fill="#00b7ff"/><path d="M266.687,1.168l-10.5,26.239L245.757,1.168H232.443V39.8L224.328,24.86a10.322,10.322,0,0,0,4.317-4.471,14.044,14.044,0,0,0,1.5-6.486q0-12.735-14.692-12.735H201.778v.024c.143.146.289.287.43.438q7.529,8.084,7.528,20.19,0,12.264-7.528,20.347c-.141.151-.287.292-.43.439v.023h10.256V27.289h3.117l7.5,15.34h19.631V15.443l9.235,23.81h9.415l9.236-23.81V42.629H280V1.168ZM218.42,17.605a4.531,4.531,0,0,1-3.328,1.214h-3.058V9.875h2.578q5.037,0,5.037,4.383A4.492,4.492,0,0,1,218.42,17.605Z" transform="translate(0 -0.399)" fill="#fff"/><path d="M134.592,1.168V8.311a13.423,13.423,0,0,0-.649-1.19,21.251,21.251,0,0,0-2.4-3.05,10.869,10.869,0,0,0-4.078-2.665A15.483,15.483,0,0,0,121.739.4Q115.5.4,111.724,3.775a10.907,10.907,0,0,0-3.5,6.112V1.168H75.962l-9.475,29.5-9.475-29.5H45.737L60.91,42.629H72.064L85.857,4.938V42.629h22.849V37.22a22.841,22.841,0,0,0,2,2.359,11.986,11.986,0,0,0,4.318,2.754,16.191,16.191,0,0,0,6,1.066q6.777,0,10.735-3.642a12.32,12.32,0,0,0,3.958-9.507,10.476,10.476,0,0,0-1.8-6.1,12.825,12.825,0,0,0-4.378-4.027,56.7,56.7,0,0,0-5.157-2.517A26.046,26.046,0,0,1,120,15.3a3.39,3.39,0,0,1-1.8-2.754,2.548,2.548,0,0,1,.9-1.985,3.478,3.478,0,0,1,2.4-.8,4.74,4.74,0,0,1,2.609.71,5.6,5.6,0,0,1,1.619,1.452,12.854,12.854,0,0,1,1.05,1.924l7.991-3.612h8.88v32.4H153.9v-32.4h3.738a27.192,27.192,0,0,1,5.45-8.6c.148-.159.3-.307.452-.462ZM120.84,26.786a12.1,12.1,0,0,1,3.208,1.895,3.1,3.1,0,0,1,1.289,2.34q0,2.9-3.718,2.9A5.839,5.839,0,0,1,117.9,32.59a8.887,8.887,0,0,1-2.579-3.287l-8.576,4.205c.007.019.018.039.025.059H96.112v-7.4h10.315v-9H96.112v-6.93H108.16a14.41,14.41,0,0,0-.214,2.487,11.685,11.685,0,0,0,1.289,5.568,11.256,11.256,0,0,0,3.209,3.85,33.332,33.332,0,0,0,4.2,2.636Q118.92,25.986,120.84,26.786Z" transform="translate(0 -0.399)" fill="#fff"/></svg>
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 280 43" class="logo-dark logo-img" height="28"><path d="M10.255,1.168V42.629H0V1.168Z" transform="translate(0 -0.399)" fill="#2a3a63"/><polygon points="38.861 0.79 38.861 26.476 23.508 0.77 13.073 0.77 13.073 42.231 23.148 42.231 23.148 16.821 38.741 42.231 48.936 42.231 48.936 28.13 38.861 0.79" fill="#2a3a63"/><path d="M197.481,37.268Q191.772,43.4,182.649,43.4t-14.831-6.131q-5.709-6.129-5.709-15.429a21.6,21.6,0,0,1,5.709-15.31Q173.527.4,182.649.4t14.832,6.13a21.6,21.6,0,0,1,5.709,15.31Q203.19,31.139,197.481,37.268Zm-7.22-23.987a10.208,10.208,0,0,0-15.223,0,12.56,12.56,0,0,0-2.967,8.558,12.729,12.729,0,0,0,2.967,8.677,10.208,10.208,0,0,0,15.223,0,12.734,12.734,0,0,0,2.967-8.677A12.565,12.565,0,0,0,190.261,13.281Z" transform="translate(0 -0.399)" fill="#00b7ff"/><path d="M266.687,1.168l-10.5,26.239L245.757,1.168H232.443V39.8L224.328,24.86a10.322,10.322,0,0,0,4.317-4.471,14.044,14.044,0,0,0,1.5-6.486q0-12.735-14.692-12.735H201.778v.024c.143.146.289.287.43.438q7.529,8.084,7.528,20.19,0,12.264-7.528,20.347c-.141.151-.287.292-.43.439v.023h10.256V27.289h3.117l7.5,15.34h19.631V15.443l9.235,23.81h9.415l9.236-23.81V42.629H280V1.168ZM218.42,17.605a4.531,4.531,0,0,1-3.328,1.214h-3.058V9.875h2.578q5.037,0,5.037,4.383A4.492,4.492,0,0,1,218.42,17.605Z" transform="translate(0 -0.399)" fill="#2a3a63"/><path d="M134.592,1.168V8.311a13.423,13.423,0,0,0-.649-1.19,21.251,21.251,0,0,0-2.4-3.05,10.869,10.869,0,0,0-4.078-2.665A15.483,15.483,0,0,0,121.739.4Q115.5.4,111.724,3.775a10.907,10.907,0,0,0-3.5,6.112V1.168H75.962l-9.475,29.5-9.475-29.5H45.737L60.91,42.629H72.064L85.857,4.938V42.629h22.849V37.22a22.841,22.841,0,0,0,2,2.359,11.986,11.986,0,0,0,4.318,2.754,16.191,16.191,0,0,0,6,1.066q6.777,0,10.735-3.642a12.32,12.32,0,0,0,3.958-9.507,10.476,10.476,0,0,0-1.8-6.1,12.825,12.825,0,0,0-4.378-4.027,56.7,56.7,0,0,0-5.157-2.517A26.046,26.046,0,0,1,120,15.3a3.39,3.39,0,0,1-1.8-2.754,2.548,2.548,0,0,1,.9-1.985,3.478,3.478,0,0,1,2.4-.8,4.74,4.74,0,0,1,2.609.71,5.6,5.6,0,0,1,1.619,1.452,12.854,12.854,0,0,1,1.05,1.924l7.991-3.612h8.88v32.4H153.9v-32.4h3.738a27.192,27.192,0,0,1,5.45-8.6c.148-.159.3-.307.452-.462ZM120.84,26.786a12.1,12.1,0,0,1,3.208,1.895,3.1,3.1,0,0,1,1.289,2.34q0,2.9-3.718,2.9A5.839,5.839,0,0,1,117.9,32.59a8.887,8.887,0,0,1-2.579-3.287l-8.576,4.205c.007.019.018.039.025.059H96.112v-7.4h10.315v-9H96.112v-6.93H108.16a14.41,14.41,0,0,0-.214,2.487,11.685,11.685,0,0,0,1.289,5.568,11.256,11.256,0,0,0,3.209,3.85,33.332,33.332,0,0,0,4.2,2.636Q118.92,25.986,120.84,26.786Z" transform="translate(0 -0.399)" fill="#2a3a63"/></svg>
                        @endif
                    </span>
                    @if (!empty(config('app.desc')))
                    <span class="d-block font-italic test-dark fw-medium mt-1 mb-1">
                        {!! config('app.desc') !!}
                    </span>
                    @endif
                </div>

                <div class="card card-bordered">
                    <div class="card-inner-group">
                        <div class="card-inner">
                            <div class="nk-block-head nk-block-head-lg text-center">
                                <h4 class="title mb-3 text-primary">{!! config('app.system').' License Activation' !!}</h4>
                                <p class="text-dark">{!! "<strong>Congratulations!</strong> You've successfully installed the application, so please activate the appliation to unlock." !!}</p>
                            </div>
                        </div>
                        <div class="card-inner card-inner-lg">
                            <div class="row gy-4 gx-5">
                                <div class="col-md-6 col-lg-7">
                                    @include('Utility::system.register')
                                </div>
                                <div class="col-md-6 col-lg-5">
                                    @include('Utility::system.info')
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="nk-footer">
            <div class="container wide-lg">
                <div class="nk-block-content text-center">
                    <p class="text-soft">{!! 'Copyright &copy; Softnio '.date('Y').'. All Rights Reserved. Developed by <a href="https://softnio.com" target="_blank">Softnio</a>.' !!}</p>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="{{ asset('/assets/js/bundle.js') }}"></script>
<script src="{{ asset('/assets/js/app.js') }}"></script>
</body>
</html>
