<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| User Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register user related web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "user" middleware group. Now create something great!
|
*/

use App\Http\Controllers\User\UserDashboardController;
use App\Http\Controllers\User\ProfileController;
use App\Http\Controllers\User\WithdrawAccountController;
use App\Http\Controllers\User\SettingsController;
use App\Http\Controllers\User\ActivityController;
use App\Http\Controllers\User\TransactionController;
use App\Http\Controllers\User\ReferralController;

Route::get('dashboard', [UserDashboardController::class, 'index'])->name('dashboard');
Route::get('profile', [ProfileController::class, 'view'])->name('account.profile');
Route::get('profile/accounts', [WithdrawAccountController::class, 'view'])->name('account.withdraw-accounts');
Route::get('profile/settings', [SettingsController::class, 'view'])->name('account.settings');

Route::get('profile/activity', [ActivityController::class, 'view'])->name('account.activity');
Route::get('profile/activity/clear', [ActivityController::class, 'clearActivity'])->name('account.activity.clear');
Route::get('profile/activity/{id}', [ActivityController::class, 'destroy'])->name('account.activity.delete');

Route::post('profile/personal', [ProfileController::class, 'savePersonalInfo'])->name('account.profile.personal');
Route::post('profile/address', [ProfileController::class, 'saveAddressInfo'])->name('account.profile.address');
Route::post('profile/change-unverified-email', [ProfileController::class, 'updateUnverifiedEmail'])->name('account.profile.update-unverified-email');
Route::post('profile/verify-unverified-email', [ProfileController::class, 'verifyUnverifiedEmail'])->name('account.profile.verify-unverified-email');
Route::post('profile/code-unverified-email', [ProfileController::class, 'codeUnverifiedEmail'])->name('account.profile.verify-unverified-code');

Route::post('profile/preference', [SettingsController::class, 'preference'])->name('account.preference');
Route::post('profile/settings', [SettingsController::class, 'saveSettings'])->name('account.settings.save');
Route::post('profile/settings/email', [SettingsController::class, 'changeEmail'])->name('account.settings.change.email');
Route::post('profile/settings/email/resend', [SettingsController::class, 'resendVerification'])->name('account.settings.change.email.resend');
Route::post('profile/settings/email/cancel', [SettingsController::class, 'cancelRequest'])->name('account.settings.change.email.cancel');
Route::post('profile/settings/password', [SettingsController::class, 'changePassword'])->name('account.settings.change.password');
Route::post('profile/settings/password/new', [SettingsController::class, 'addPassword'])->name('account.settings.add.password');
Route::post('profile/settings/2fa/{state}', [SettingsController::class, 'google2fa'])->name('account.settings.2fa');
Route::post('profile/settings/social/{platform}/{action}', [SettingsController::class, 'social'])->name('account.settings.social');
Route::post('update/setting', [SettingsController::class, 'updateUserSettings'])->name('update.setting');

Route::get('deposit', [TransactionController::class, 'depositPaymentMethod'])->name('deposit');
Route::get('deposit/online/{status}/{tnx?}', [TransactionController::class, 'onlineDepositComplete'])->name('deposit.complete.online');
Route::get('deposit/{status}/{tnx?}', [TransactionController::class, 'depositComplete'])->name('deposit.complete');
Route::post('deposit/amount', [TransactionController::class, 'depositAmount'])->name('deposit.amount.form');
Route::post('deposit/preview', [TransactionController::class, 'depositPreview'])->name('deposit.preview.form');
Route::post('deposit/confirm', [TransactionController::class, 'depositConfirm'])->name('deposit.confirm');

Route::get('withdraw', [TransactionController::class, 'showWithdrawMethod'])->name('withdraw');
Route::get('withdraw/redirect/amount', [TransactionController::class, 'withdrawAmount'])->name('withdraw.redirect.amount');
Route::post('withdraw/amount', [TransactionController::class, 'withdrawAmount'])->name('withdraw.amount.form');
Route::post('withdraw/preview', [TransactionController::class, 'withdrawPreview'])->name('withdraw.preview.form');
Route::post('withdraw/confirm', [TransactionController::class, 'withdrawConfirm'])->name('withdraw.confirm');

Route::get('transactions', [TransactionController::class, 'list'])->name('transaction.list');
Route::get('transactions/details', [TransactionController::class, 'viewTransactionDetails'])->name('transaction.details');
Route::get('transaction/{status}/{tnx?}', [TransactionController::class, 'actionTransactionStatus'])->name('transaction.action');

Route::get('referrals', [ReferralController::class, 'index'])->name('referrals');

// Welcome setup
Route::get('welcome', [ProfileController::class, 'welcome'])->name('account.welcome');
Route::get('congratulation', [ProfileController::class, 'congrats'])->name('account.congrats');

Route::post('profile/complete', [ProfileController::class, 'completeProfile'])->name('account.profile.complete');
Route::post('validate/username', [ProfileController::class, 'validateUsername'])->name('validate.username');
