<?php
# This Code is Cracked by dharunMods-YouTube-Channel

use Illuminate\Support\Facades\Route;

// Admin routes
Route::name('admin.')->middleware('admin')->prefix('admin')->group(function () {

    // KYC routes
    Route::name('kyc.')->prefix('/kyc')->group(function () {
        Route::get('/applicants/{state?}', 'AdminKycController@index')->name('list');
        Route::get('/applicant/view/{session}', 'AdminKycController@viewSubmission')->name('view');
        Route::get('/download/{part}', 'AdminKycController@downloadDocFile')->name('download');
        Route::post('/submission/{session}/update', 'AdminKycController@updateStatus')->name('update');
    });

    // Settings routes
    Route::name('settings.')->prefix('/settings')->group(function () {
        Route::get('/component/basic-kyc', 'KycSettingsController@index')->name('component.kyc');
        Route::post('/component/basic-kyc/update', 'KycSettingsController@saveSettings')->name('component.kyc.update');
    });
});

// User KYC Routes
Route::get('identity-verification', 'UserKycController@verification')
    ->middleware(['user', 'basickyc-state', 'basickyc-allow'])
    ->name('user.kyc.verify');

Route::name('user.kyc.')
    ->middleware(['user', 'basickyc-state', 'basickyc-allow'])
    ->prefix('kyc')
    ->group(function () {
        Route::post('/proceed', 'UserKycController@proceedNext')->name('verify.next');
        Route::post('/uploader', 'UserKycController@handleFiles')->name('verify.files');
        Route::post('/basic', 'UserKycController@basicInfo')->name('verify.basic');
        Route::post('/basic/form', 'UserKycController@basicInfoForm')->name('verify.basic.form');
        Route::post('/basic/update', 'UserKycController@basicInfoUpdate')->name('verify.basic.info.update');
        Route::post('/basic/address', 'UserKycController@basicAddressUpdate')->name('verify.basic.address.update');
        Route::post('/docs', 'UserKycController@documents')->name('verify.documents');
        Route::post('/docs/form', 'UserKycController@documentsUpdate')->name('verify.documents.update');
        Route::post('/docs/upload', 'UserKycController@documentsUploadUpdate')->name('verify.documents.upload');
        Route::post('/proof', 'UserKycController@additional')->name('verify.additional');
        Route::post('/proof/upload', 'UserKycController@additionalUpdate')->name('verify.additional.upload');
        Route::post('/confirm', 'UserKycController@submitKyc')->name('submit.application');
        Route::get('/cancel', 'UserKycController@cancelKyc')->name('cancel.application');
    });
