<?php
#This Code is Cracked by dharunMods-YouTube-Channel


namespace NioModules\BasicKYC\RequestFilters;

class StateFilter
{
    public function handle($request, \Closure $next)
    {
        $userId = auth()->user()->id;
        $applicant = \NioModules\BasicKYC\Models\KycApplicants::where("user_id", $userId)->first();
        if (!blank($applicant) && $applicant->status == \NioModules\BasicKYC\Helpers\KycStatus::VERIFIED) {
            return response()->view("BasicKYC::user.verification-verified");
        }
        if (!blank($applicant) && in_array($applicant->status, [\NioModules\BasicKYC\Helpers\KycStatus::PENDING, \NioModules\BasicKYC\Helpers\KycStatus::REJECTED])) {
            $status = module_msg_of($applicant->status, "status", "BasicKYC");
            if ($request->ajax()) {
                return response()->view("BasicKYC::user.misc.notice", $status);
            }
            return response()->view("BasicKYC::user.verification-status", $status);
        }
        return $next($request);
    }
}

?>