<?php
#This Code is Cracked by dharunMods-YouTube-Channel


namespace NioModules\BasicKYC\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Filters\Filterable; 
class KycSessions extends Model
{
    use HasFactory, Filterable;

    protected $fillable = [
        'status',
        'checked_by',
        'checked_at',
    ];

    protected $casts = [
        "docs" => "array",
        "profile" => "array",
        "revised" => "array",
        "checked_by" => "array"
    ];
    public function scopeStarted($query)
    {
        return $query->where("status", \NioModules\BasicKYC\Helpers\KycSessionStatus::STARTED)->orderBy("id", "desc");
    }
    public function user()
    {
        return $this->belongsTo("App\\Models\\User", "user_id");
    }
    public function kyc()
    {
        return $this->belongsTo("NioModules\\BasicKYC\\Models\\KycApplicants", "user_id", "user_id");
    }
    public function documents()
    {
        return $this->hasMany("NioModules\\BasicKYC\\Models\\KycDocs", "session_id");
    }
    public function document($type)
    {
        if (!empty($type) && in_array($type, ["bs", "ub"])) {
            return $this->documents->where("type", $type)->sortByDesc("id")->first();
        }
        if (!empty($type) && $type == "proof") {
            return $this->documents->whereIn("type", ["bs", "ub"])->sortByDesc("id")->first();
        }
        return $this->documents->whereIn("type", ["pp", "nid", "dvl"])->sortByDesc("id")->first();
    }
    public function doc_main()
    {
        return $this->document("main");
    }
    public function doc_bs()
    {
        return $this->document("bs");
    }
    public function doc_ub()
    {
        return $this->document("ub");
    }
    public function data($key = NULL)
    {
        if (!empty($key)) {
            return data_get($this->profile, $key);
        }
        return $this->profile;
    }
    public function in_docs($key)
    {
        $docs = $this->docs;
        if (in_array($key, ["pp", "nid", "dvl"])) {
            return data_get($docs, "main") == $key ? true : false;
        }
        if (in_array($key, ["ub", "bs"])) {
            return in_array($key, data_get($docs, "proof")) ? true : false;
        }
        return NULL;
    }
    public function getMainDocTypeAttribute()
    {
        return data_get($this->doc_main(), "type");
    }
    public function getMainDocMetaAttribute()
    {
        return data_get($this->doc_main(), "meta", []);
    }
    public function getMainDocFilesAttribute()
    {
        return data_get($this->doc_main(), "files", []);
    }
}

?>