<?php
#This Code is Cracked by dharunMods-YouTube-Channel


namespace NioModules\BasicKYC\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Filters\Filterable;
class KycApplicants extends Model
{
     use HasFactory, Filterable;
    protected $fillable = [
    'status',
];

    public function user()
    {
        return $this->belongsTo("App\\Models\\User", "user_id");
    }
    public function sessions()
    {
        return $this->hasMany("NioModules\\BasicKYC\\Models\\KycSessions", "user_id", "user_id");
    }
    public function entry()
    {
        return $this->sessions->sortByDesc("id")->first();
    }
    public function profile($key = NULL)
    {
        $entry = $this->entry();
        $metas = data_get($entry, "profile", []);
        if (!empty($key)) {
            return \Illuminate\Support\Arr::get($metas, $key) ? \Illuminate\Support\Arr::get($metas, $key) : false;
        }
        return $metas;
    }
    public function docs()
    {
        return $this->hasMany("NioModules\\BasicKYC\\Models\\KycDocs", "user_id", "user_id");
    }
    public function getUserReferenceAttribute()
    {
        $key = config("modules.basic-kyc.prefix");
        $prefix = $key ? $key : "";
        return $prefix . $this->attributes["reference"];
    }
}

?>