<?php
#This Code is Cracked by dharunMods-YouTube-Channel


namespace NioModules\BasicKYC\Controllers;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
class UserKycController extends Controller
{
    private $kycModule;
    private $pathTemp;
    private $pathSave;
    private $docKeys;
    public function __construct(\NioModules\BasicKYC\BasicKYCModule $module)
    {
        $this->kycModule = $module;
        $this->pathTemp = "kyc-temp";
        $this->pathSave = "kyc";
        $this->docKeys = ["main", "front", "back", "proof", "bs", "ub"];
    }
    public function verification()
   {
    $userId = auth()->user()->id;
    \Log::info("KYC Verification - User ID: {$userId}");

    $getApplicant = \NioModules\BasicKYC\Models\KycApplicants::where("user_id", $userId)->first();
    \Log::info("KYC Applicant:", ['applicant' => $getApplicant]);

    $getSession = \NioModules\BasicKYC\Models\KycSessions::started()->where("user_id", $userId)->first();
    \Log::info("KYC Session:", ['session' => $getSession]);

    $status = !blank($getSession) ? data_get($getSession, "status") : "none";
    $kycStatus = !blank($getApplicant) ? data_get($getApplicant, "status") : "new";
    \Log::info("KYC Status Summary", ['status' => $status, 'kyc_status' => $kycStatus]);

    $additional = $document = $basic = false;

    if (!blank($getSession)) {
        $basic = $this->isProfileInfoExist($this->getBasicInfo());
        \Log::info("Basic Info Exists:", ['basic' => $basic]);

        $mainDoc = $getSession->document("main");
        $document = $this->hasDocsFiles($mainDoc);
        \Log::info("Main Document Exists:", ['document' => $document]);

        $both = $this->docsAlter("req");
        $proof = data_get($getSession, "docs.proof", []);
        \Log::info("Proof Documents:", ['proof' => $proof, 'both' => $both]);

        if (!empty($proof)) {
            if (!$both && 1 <= count($proof)) {
                $additional = true;
            } elseif ($both && count($proof) == 2) {
                $additional = true;
            }
        }

        \Log::info("Additional Documents Valid:", ['additional' => $additional]);
    }

    return view("BasicKYC::user.verification", [
        "resubmit" => $kycStatus == \NioModules\BasicKYC\Helpers\KycStatus::RESUBMIT,
        "basic" => $basic,
        "document" => $document,
        "additional" => $additional,
        "status" => $status
    ]);
}

    public function proceedNext(\Illuminate\Http\Request $request)
    {
        $userId = auth()->user()->id;
        $getApplicant = \NioModules\BasicKYC\Models\KycApplicants::where("user_id", $userId)->first();
        $getSession = \NioModules\BasicKYC\Models\KycSessions::started()->where("user_id", $userId)->first();
        if (blank($getSession)) {
            return $this->basicInfo();
        }
        if (\NioModules\BasicKYC\BasicKYCModule::isInvalid()) {
            throw \Illuminate\Validation\ValidationException::withMessages(["invalid" => __("We are temporarily unable to process your request. Please try again later.")]);
        }
        if (!blank($getSession)) {
            $isBasic = \Illuminate\Support\Facades\Session::get("basic_complete", "no");
            if (!$this->isProfileInfoExist($this->getBasicInfo()) || $isBasic == "no") {
                return $this->basicInfo();
            }
            $mainDoc = $getSession->document("main");
            if (blank($mainDoc) || !data_get($mainDoc, "files") || !data_get($mainDoc, "meta")) {
                return $this->documents();
            }
            $bs = $this->docsAlter("bs");
            $ub = $this->docsAlter("ub");
            $both = $this->docsAlter("req");
            $bsDoc = $getSession->document("bs");
            $ubDoc = $getSession->document("ub");
            $proof = data_get($getSession, "docs.proof", []);
            if (empty($proof) || $both && count($proof) < 2) {
                return $this->additional();
            }
            if ($both && (!data_get($bsDoc, "files") || !data_get($ubDoc, "files")) || $bs && $ub && !$both && !data_get($bsDoc, "files") && !data_get($ubDoc, "files") || $bs && !$ub && !data_get($bsDoc, "files") || $ub && !$bs && !data_get($ubDoc, "files")) {
                return $this->additional();
            }
            return $this->finalPreview();
        }
        throw \Illuminate\Validation\ValidationException::withMessages(["error" => __("Sorry, we are unable to proceed your request. Please reload the page and try again.")]);
    }
    private function finalPreview()
    {
        $userId = auth()->user()->id;
        $getSession = \NioModules\BasicKYC\Models\KycSessions::started()->where("user_id", $userId)->first();
        if (!blank($getSession)) {
            $main = $getSession->document("main");
            $bs = $getSession->document("bs");
            $ub = $getSession->document("ub");
            if (!$this->isProfileInfoExist($getSession->profile)) {
                return $this->basicInfo();
            }
            if (!$this->hasDocsFiles($main)) {
                return $this->documents();
            }
            $session_id = data_get($getSession, "session");
            return view("BasicKYC::user.from-final-preview", ["data" => $getSession, "main" => $main, "bs" => $bs, "ub" => $ub, "session" => $session_id]);
        }
        throw \Illuminate\Validation\ValidationException::withMessages(["warning" => __("Something went wrong. Please reload the page and try again.")]);
    }
    public function submitKyc(\Illuminate\Http\Request $request)
    {
        $sessionHash = $request->get("identity");
        if (empty($sessionHash)) {
            throw \Illuminate\Validation\ValidationException::withMessages(["warning" => __("Something went wrong. Please reload the page and try again.")]);
        }
        $userId = auth()->user()->id;
        $getSession = \NioModules\BasicKYC\Models\KycSessions::started()->where("user_id", $userId)->first();
        if (!blank($getSession) && data_get($getSession, "session") == get_hash($sessionHash)) {
            $stopSubmit = false;
            if (empty($getSession->docs) || !$this->isProfileInfoExist($getSession->profile) || !$this->hasDocsFiles($getSession->document("main"))) {
                $stopSubmit = true;
            }
            if (in_array("bs", data_get($getSession, "docs.proof", [])) && !$this->hasDocsFiles($getSession->document("bs"))) {
                $stopSubmit = true;
            }
            if (in_array("ub", data_get($getSession, "docs.proof", [])) && !$this->hasDocsFiles($getSession->document("ub"))) {
                $stopSubmit = true;
            }
            if ($stopSubmit) {
                throw \Illuminate\Validation\ValidationException::withMessages(["warning" => __("Something went wrong. Please reload the page and try again.")]);
            }
            try {
                return $this->wrapInTransaction(function () use ($request, $userId, $getSession) {
                    $this->moveSubmittedFiles($getSession);
                    $getKycApplicant = \NioModules\BasicKYC\Models\KycApplicants::where("user_id", $userId)->first();
                    $getKycApplicant->status = \NioModules\BasicKYC\Helpers\KycStatus::PENDING;
                    $getKycApplicant->save();
                    $getSession->created_at = \Carbon\Carbon::now();
                    $getSession->status = \NioModules\BasicKYC\Helpers\KycSessionStatus::COMPLETED;
                    $getSession->save();
                    \App\Models\UserMeta::updateOrCreate(["user_id" => $userId, "meta_key" => "kyc_verification"], ["meta_value" => "pending"]);
                    \Illuminate\Support\Facades\Session::put("basic_complete", "no");
                    $success = module_msg_of("success", "status", "BasicKYC");
                    return view("BasicKYC::user.misc.notice", $success);
                });
            } catch (\Exception $e) {
                save_error_log($e);
                throw \Illuminate\Validation\ValidationException::withMessages(["error" => __("Sorry, we are unable to proceed your request.")]);
            }
        } else {
            throw \Illuminate\Validation\ValidationException::withMessages(["warning" => __("Something went wrong. Please reload the page and try again.")]);
        }
    }
    public function cancelKyc()
    {
        $getSession = \NioModules\BasicKYC\Models\KycSessions::started()->where("user_id", auth()->user()->id)->first();
        $this->removeSubmittedFiles($getSession);
        \Illuminate\Support\Facades\Session::put("basic_complete", "no");
        return redirect()->route("user.kyc.verify");
    }
    private function isProfileInfoExist($profileData): bool
    {
        $profileFields = \Illuminate\Support\Arr::get(gss("kyc_fields"), "profile");
        foreach ($profileFields as $key => $item) {
            if (\Illuminate\Support\Arr::get($item, "show") == "yes" && \Illuminate\Support\Arr::get($item, "req") == "yes") {
                switch ($key) {
                    case "address":
                        if (!\Illuminate\Support\Arr::get($profileData, "address_line_1") || !\Illuminate\Support\Arr::get($profileData, "state")) {
                            return false;
                        }
                        break;
                    case "country":
                        if (!\Illuminate\Support\Arr::get($profileData, "country")) {
                            return false;
                        }
                        break;
                    case "nationality":
                        if (!\Illuminate\Support\Arr::get($profileData, "nationality")) {
                            return false;
                        }
                        break;
                    case "gender":
                        if (!\Illuminate\Support\Arr::get($profileData, "gender")) {
                            return false;
                        }
                        break;
                    case "phone":
                        if (!\Illuminate\Support\Arr::get($profileData, "phone")) {
                            return false;
                        }
                        break;
                    case "dob":
                        if (!\Illuminate\Support\Arr::get($profileData, "dob")) {
                            return false;
                        }
                        break;
                    case "name":
                        if (!\Illuminate\Support\Arr::get($profileData, "name")) {
                            return false;
                        }
                        break;
                }
            }
        }
        return true;
    }
    private function getBasicInfo(): array
    {
        $userId = auth()->user()->id;
        $userMeta = \App\Models\UserMeta::where("user_id", $userId)->pluck("meta_value", "meta_key")->toArray();
        if (!empty($userMeta)) {
            $userMeta = array_filter((array) $userMeta);
        }
        $kycProfile = \NioModules\BasicKYC\Models\KycSessions::started()->where("user_id", $userId)->first();
        if (!empty($kycProfile["profile"])) {
            $kycProfile = array_filter((array) $kycProfile["profile"]);
        }
        $nationality = \Illuminate\Support\Arr::get($userMeta, "profile_nationality") == "same" ? \Illuminate\Support\Arr::get($userMeta, "profile_country") : \Illuminate\Support\Arr::get($userMeta, "profile_nationality");
        return ["name" => \Illuminate\Support\Arr::get($kycProfile, "name", auth()->user()->name), "phone" => \Illuminate\Support\Arr::get($kycProfile, "phone", \Illuminate\Support\Arr::get($userMeta, "profile_phone")), "dob" => \Illuminate\Support\Arr::get($kycProfile, "dob", \Illuminate\Support\Arr::get($userMeta, "profile_dob")), "gender" => \Illuminate\Support\Arr::get($kycProfile, "gender", \Illuminate\Support\Arr::get($userMeta, "profile_gender")), "nationality" => \Illuminate\Support\Arr::get($kycProfile, "nationality", $nationality), "address_line_1" => \Illuminate\Support\Arr::get($kycProfile, "address_line_1", \Illuminate\Support\Arr::get($userMeta, "profile_address_line_1")), "address_line_2" => \Illuminate\Support\Arr::get($kycProfile, "address_line_2", \Illuminate\Support\Arr::get($userMeta, "profile_address_line_2")), "city" => \Illuminate\Support\Arr::get($kycProfile, "city", \Illuminate\Support\Arr::get($userMeta, "profile_city")), "state" => \Illuminate\Support\Arr::get($kycProfile, "state", \Illuminate\Support\Arr::get($userMeta, "profile_state")), "zip" => \Illuminate\Support\Arr::get($kycProfile, "zip", \Illuminate\Support\Arr::get($userMeta, "profile_zip")), "country" => \Illuminate\Support\Arr::get($kycProfile, "country", \Illuminate\Support\Arr::get($userMeta, "profile_country"))];
    }
    public function basicInfo()
    {
        $userId = auth()->user()->id;
        $kycApplicant = \NioModules\BasicKYC\Models\KycApplicants::where("user_id", $userId)->first();
        $getSession = \NioModules\BasicKYC\Models\KycSessions::started()->where("user_id", $userId)->first();
        $basicInfo = $this->getBasicInfo();
        if (blank($kycApplicant)) {
            $this->addNewApplicant();
        }
        if (blank($getSession)) {
            $addSession = $this->addNewSession($basicInfo);
            $getSession = $addSession;
        }
        $session_id = data_get($getSession, "session");
        if (gss("kyc_preview_quick", "yes") == "yes" && $this->isProfileInfoExist($basicInfo)) {
            \Illuminate\Support\Facades\Session::put("basic_complete", "yes");
            return view("BasicKYC::user.form-basic-preview", ["basicInfo" => $basicInfo, "session" => $session_id]);
        }
        $countries = filtered_countries();
        return view("BasicKYC::user.form-basic", ["basicInfo" => $basicInfo, "countries" => $countries, "session" => $session_id]);
    }
    public function basicInfoForm(\Illuminate\Http\Request $request)
    {
        $getSession = \NioModules\BasicKYC\Models\KycSessions::started()->where("user_id", auth()->user()->id)->first();
        $session_id = data_get($getSession, "session");
        $countries = filtered_countries();
        return view("BasicKYC::user.form-basic", ["session" => $session_id, "basicInfo" => $this->getBasicInfo(), "countries" => $countries]);
    }
    public function basicInfoUpdate(\Illuminate\Http\Request $request)
    {
        $rules = [];
        $messages = [];
        $settings = data_get(gss("kyc_fields"), "profile");
        $redirect = data_get($settings, "address.show") == "yes" ? true : false;
        $rules["name"] = "required|string|max:190";
        $messages["name.required"] = __("Please enter your full name.");
        if (data_get($settings, "phone.show") == "yes") {
            $rules["phone"] = data_get($settings, "phone.req") == "no" ? "nullable|string" : "required|string|max:50";
            $messages["phone.required"] = __("Please enter your phone number.");
        }
        if (data_get($settings, "dob.show") == "yes") {
            $rules["dob"] = data_get($settings, "dob.req") == "no" ? "nullable|date_format:m/d/Y" : "required|date_format:m/d/Y";
            $messages["dob.required"] = __("Please enter your date of birth.");
            $messages["dob.date_format"] = __("Enter date of birth in this 'mm/dd/yyyy' format.");
        }
        if (data_get($settings, "gender.show") == "yes") {
            $rules["gender"] = data_get($settings, "gender.req") == "no" ? "nullable|string|max:10" : "required|string|max:10";
            $messages["gender.required"] = __("Please select your gender.");
        }
        if (data_get($settings, "nationality.show") == "yes") {
            $rules["nationality"] = data_get($settings, "nationality.req") == "no" ? "nullable|string|max:50" : "required|string|max:50";
            $messages["nationality.required"] = __("Please select your nationality.");
        }
        if (data_get($settings, "address.show") == "no") {
            $rules["country"] = "required|string|max:50";
            $messages["country.required"] = __("Please select country of residence.");
        }
        $validatedData = request()->validate($rules, $messages);
        $updateData = \Illuminate\Support\Arr::only($validatedData, ["name", "phone", "dob", "gender", "nationality", "country"]);
        $updateData = array_map("strip_tags_map", $updateData);
        if (\NioModules\BasicKYC\BasicKYCModule::isInvalid()) {
            throw \Illuminate\Validation\ValidationException::withMessages(["invalid" => __("We are temporarily unable to process your request. Please try again later.")]);
        }
        $userId = auth()->user()->id;
        $getSession = \NioModules\BasicKYC\Models\KycSessions::started()->where("user_id", $userId)->first();
        if (!blank($getSession) && data_get($getSession, "session") == get_hash($request->get("identity"))) {
            try {
                $this->wrapInTransaction(function () use ($getSession, $updateData) {
                    $getSession->profile = array_merge(data_get($getSession, "profile", []), $updateData);
                    $getSession->save();
                });
            } catch (\Exception $e) {
                save_error_log($e);
                throw \Illuminate\Validation\ValidationException::withMessages(["error" => __("Sorry, we are unable to proceed your request.")]);
            }
            \Illuminate\Support\Facades\Session::put("basic_complete", "yes");
            $session_id = data_get($getSession, "session");
            $countries = filtered_countries();
            if ($redirect) {
                return view("BasicKYC::user.form-basic-address", ["basicInfo" => $this->getBasicInfo(), "countries" => $countries, "session" => $session_id]);
            }
            return $this->documents();
        }
        throw \Illuminate\Validation\ValidationException::withMessages(["warning" => __("Something went wrong. Please reload the page and try again.")]);
    }
    public function basicAddressUpdate(\Illuminate\Http\Request $request)
    {
        $rules = [];
        $messages = [];
        $require = data_get(gss("kyc_fields"), "profile.address.req") == "yes" ? true : false;
        $rules["address_line_1"] = $require ? "required|string|max:100" : "nullable|string|max:100";
        $rules["address_line_2"] = "nullable|string|max:100";
        $rules["city"] = $require ? "required|string|max:50" : "nullable|string|max:100";
        $rules["state"] = "nullable|string|max:50";
        $rules["zip"] = "nullable|string|max:20";
        $rules["country"] = "required|string|max:50";
        $messages["address_line_1.required"] = __("Please enter your valid address.");
        $messages["city.required"] = __("Please enter your city name.");
        $messages["country.required"] = __("Please select your country name.");
        $validatedData = request()->validate($rules, $messages);
        $updateData = \Illuminate\Support\Arr::only($validatedData, ["address_line_1", "address_line_2", "city", "state", "zip", "country"]);
        $updateData = array_map("strip_tags_map", $updateData);
        if (\NioModules\BasicKYC\BasicKYCModule::isInvalid()) {
            throw \Illuminate\Validation\ValidationException::withMessages(["invalid" => __("We are temporarily unable to process your request. Please try again later.")]);
        }
        $userId = auth()->user()->id;
        $getSession = \NioModules\BasicKYC\Models\KycSessions::started()->where("user_id", $userId)->first();
        if (!blank($getSession) && data_get($getSession, "session") == get_hash($request->get("identity"))) {
            try {
                $this->wrapInTransaction(function () use ($getSession, $updateData) {
                    $getSession->profile = array_merge(data_get($getSession, "profile", []), $updateData);
                    $getSession->save();
                });
            } catch (\Exception $e) {
                save_error_log($e);
                throw \Illuminate\Validation\ValidationException::withMessages(["error" => __("Sorry, we are unable to proceed your request.")]);
            }
            return $this->documents();
        }
        throw \Illuminate\Validation\ValidationException::withMessages(["warning" => __("Something went wrong. Please reload the page and try again.")]);
    }
    public function documents()
    {
        $getSession = \NioModules\BasicKYC\Models\KycSessions::started()->where("user_id", auth()->user()->id)->first();
        if (!blank($getSession)) {
            $mainDoc = $getSession->document("main");
            $countries = filtered_countries();
            $session_id = data_get($getSession, "session");
            $this->fileCleanup($getSession, "document");
            return view("BasicKYC::user.form-docs", ["userDoc" => $mainDoc, "countries" => $countries, "session" => $session_id]);
        }
        throw \Illuminate\Validation\ValidationException::withMessages(["warning" => __("Something went wrong. Please reload the page and try again.")]);
    }
    public function documentsUpdate(\Illuminate\Http\Request $request)
    {
        $fields = data_get(gss("kyc_docs"), "field");
        $rules = ["type" => "required|in:pp,nid,dvl", "country" => "required|string|max:50"];
        $messages = ["type.in" => __("Please select a valid document type."), "type.required" => __("Please select the type of document."), "country.required" => __("Please select the issued by country.")];
        if (data_get($fields, "id.show") == "on") {
            $rules["number"] = data_get($fields, "id.req") == "on" ? "required|string|max:50" : "nullable|string|max:50";
            $messages["number.required"] = __("Please enter your document number.");
        }
        if (data_get($fields, "issue.show") == "on") {
            $rules["issue"] = data_get($fields, "issue.req") == "on" ? "required|date_format:m/d/Y" : "nullable|date_format:m/d/Y";
            $messages["issue.required"] = __("Please enter your document issue date.");
            $messages["issue.date_format"] = __("Enter issue date in this 'mm/dd/yyyy' format.");
        }
        if (data_get($fields, "expiry.show") == "on") {
            $rules["expiry"] = data_get($fields, "expiry.req") == "on" ? "required|date_format:m/d/Y" : "nullable|date_format:m/d/Y";
            $messages["expiry.required"] = __("Please enter your document expiry date.");
            $messages["expiry.date_format"] = __("Enter expiry date in this 'mm/dd/yyyy' format.");
        }
        $validatedData = $request->validate($rules, $messages);
        $docType = data_get($validatedData, "type");
        $docMeta = \Illuminate\Support\Arr::only($validatedData, ["country", "number", "issue", "expiry"]);
        $docMeta = array_map("strip_tags_map", $docMeta);
        $userId = auth()->user()->id;
        $getSession = \NioModules\BasicKYC\Models\KycSessions::started()->where("user_id", $userId)->first();
        if (!blank($getSession) && data_get($getSession, "session") == get_hash($request->get("identity"))) {
            try {
                $mainDoc = $getSession->document("main");
                $mainFiles = data_get($mainDoc, "files", []);
                $document = short_to_docs($docType);
                if (!blank($mainDoc)) {
                    $this->removeExistFiles($mainFiles);
                    $mainDoc->type = $docType;
                    $mainDoc->meta = $docMeta;
                    $mainDoc->files = [];
                    $mainDoc->save();
                } else {
                    $kycDocs = new \NioModules\BasicKYC\Models\KycDocs();
                    $kycDocs->session_id = $getSession->id;
                    $kycDocs->user_id = $getSession->user_id;
                    $kycDocs->type = $docType;
                    $kycDocs->meta = $docMeta;
                    $kycDocs->save();
                    $mainDoc = $kycDocs->fresh();
                }
                $session_id = data_get($getSession, "session");
                $this->fileCleanup($getSession, "document");
                \Illuminate\Support\Facades\Session::put("main_files", []);
                return view("BasicKYC::user.form-docs-upload", ["doc" => $docType, "document" => $document, "session" => $session_id]);
            } catch (\Exception $e) {
                save_error_log($e);
                throw \Illuminate\Validation\ValidationException::withMessages(["error" => __("Sorry, we are unable to proceed your request.")]);
            }
        } else {
            throw \Illuminate\Validation\ValidationException::withMessages(["warning" => __("Something went wrong. Please reload the page and try again.")]);
        }
    }
    public function documentsUploadUpdate(\Illuminate\Http\Request $request)
    {
        $userId = auth()->user()->id;
        $getSession = \NioModules\BasicKYC\Models\KycSessions::started()->where("user_id", $userId)->first();
        $kycDocs = $getSession->document("main");
        if (blank($getSession) || blank($kycDocs) || !$this->docsMain("opt")) {
            throw \Illuminate\Validation\ValidationException::withMessages(["warning" => __("Something went wrong. Please reload the page and try again.")]);
        }
        $docFiles = \Illuminate\Support\Facades\Session::get("main_files", []);
        $docType = $request->get("docstype");
        $userDoc = data_get($kycDocs, "type");
        if ($docType != $userDoc) {
            throw \Illuminate\Validation\ValidationException::withMessages(["warning" => __("Something went wrong. Please reload the page and try again.")]);
        }
        if (empty($docFiles)) {
            throw \Illuminate\Validation\ValidationException::withMessages(["error" => __("Please upload all the necessary documents.")]);
        }
        $rules = ["docstype" => "required|in:pp,nid,dvl"];
        $messages = ["docstype.*" => __("Please select a valid document type.")];
        if ($userDoc == "pp") {
            $rules["main"] = "required|string|min:8|max:10";
            $messages["main.*"] = __("Please upload the :document.", ["document" => __(strtolower(short_to_docs($userDoc)))]);
        }
        if ($userDoc == "nid" || $userDoc == "dvl") {
            $rules["front"] = "required|string|min:8|max:10";
            $rules["back"] = "required|string|min:8|max:10";
            $messages["front.*"] = __("Please upload the :part of :document.", ["part" => __("front"), "document" => __(strtolower(short_to_docs($userDoc)))]);
            $messages["back.*"] = __("Please upload the :part of :document.", ["part" => __("back"), "document" => __(strtolower(short_to_docs($userDoc)))]);
        }
        if ($this->docsMain("proof")) {
            $rules["proof"] = "required|string|min:8|max:10";
            $messages["proof.*"] = __("Please upload the :document.", ["document" => __(strtolower(short_to_docs("proof")))]);
        }
        $input = $request->validate($rules, $messages);
        if (\NioModules\BasicKYC\BasicKYCModule::isInvalid()) {
            throw \Illuminate\Validation\ValidationException::withMessages(["invalid" => __("We are temporarily unable to process your request. Please try again later.")]);
        }
        if (!blank($kycDocs)) {
            $fileData = [];
            $docs = \Illuminate\Support\Arr::except($input, ["docstype"]);
            $type = data_get($kycDocs, "type");
            foreach ($docs as $key => $hash) {
                $file = data_get($docFiles, $key . "." . $hash);
                if (empty($file) || !\Illuminate\Support\Facades\Storage::exists($this->pathTemp . "/" . $file)) {
                    if ($key == "main") {
                        $error = __("Please upload the :document.", ["document" => __(short_to_docs(strtolower($type)))]);
                    } else if ($key == "proof") {
                        $error = __("Take a selfie with :document & upload.", ["document" => __(short_to_docs(strtolower($type)))]);
                    } else {
                        $error = __("Upload the :part copy of :document.", ["part" => __($key), "document" => __(short_to_docs(strtolower($type)))]);
                    }
                    throw \Illuminate\Validation\ValidationException::withMessages(["error" => $error]);
                }
                $fileData[$key] = $file;
            }
            if (!empty($fileData)) {
                $kycDocs->files = $fileData;
                $kycDocs->save();
                $getSession->docs = array_merge(data_get($getSession, "docs", []), ["main" => $type]);
                $getSession->save();
                return $this->additional();
            }
            $getSession->docs = array_merge(data_get($getSession, "docs", []), ["main" => NULL]);
            $getSession->save();
            throw \Illuminate\Validation\ValidationException::withMessages(["error" => __("Please upload all the documents for verification.")]);
        } else {
            throw \Illuminate\Validation\ValidationException::withMessages(["warning" => __("Something went wrong. Please reload the page and try again.")]);
        }
    }
    public function additional()
    {
        $userId = auth()->user()->id;
        $getSession = \NioModules\BasicKYC\Models\KycSessions::started()->where("user_id", $userId)->first();
        if (!blank($getSession)) {
            if ($this->docsAlter("opt")) {
                $this->fileCleanup($getSession, "additional");
                \Illuminate\Support\Facades\Session::put("proof_files", []);
                $getBsDoc = $getSession->document("bs");
                $getUbDoc = $getSession->document("ub");
                $required = $this->docsAlter("req");
                $session_id = data_get($getSession, "session");
                return view("BasicKYC::user.form-additional", ["getBsDoc" => $getBsDoc, "getUbDoc" => $getUbDoc, "bothRequire" => $required, "session" => $session_id]);
            }
            return $this->finalPreview();
        }
        throw \Illuminate\Validation\ValidationException::withMessages(["warning" => __("Something went wrong. Please reload the page and try again.")]);
    }
    public function additionalUpdate(\Illuminate\Http\Request $request)
    {
        $userId = auth()->user()->id;
        $getSession = \NioModules\BasicKYC\Models\KycSessions::started()->where("user_id", $userId)->first();
        if (!blank($getSession)) {
            $docFiles = \Illuminate\Support\Facades\Session::get("proof_files", []);
            if (empty($docFiles)) {
                throw \Illuminate\Validation\ValidationException::withMessages(["error" => __("Please upload all the necessary documents.")]);
            }
            $bs = $this->docsAlter("bs");
            $ub = $this->docsAlter("ub");
            $both = $this->docsAlter("req");
            $bsdoc = strtolower(short_to_docs("bs"));
            $ubdoc = strtolower(short_to_docs("ub"));
            $rules = $messages = [];
            if ($bs) {
                if ($both) {
                    $rules["bs"] = "required|string|min:8|max:10";
                    $messages["bs.*"] = __("Please upload the :document.", ["document" => __($bsdoc)]);
                } else {
                    $rules["bs"] = "nullable|string|min:8|max:10";
                    $messages["bs.*"] = __("Please upload the :document.", ["document" => __($bsdoc)]);
                }
            }
            if ($ub) {
                if ($both) {
                    $rules["ub"] = "required|string|min:8|max:10";
                    $messages["ub.*"] = __("Please upload the :document.", ["document" => __($ubdoc)]);
                } else {
                    $rules["ub"] = "nullable|string|min:8|max:10";
                    $messages["ub.*"] = __("Please upload the :document.", ["document" => __($ubdoc)]);
                }
            }
            $input = $request->validate($rules, $messages);
            $docs = array_filter(\Illuminate\Support\Arr::only($input, ["bs", "ub"]));
            $bsFile = data_get($docFiles, "bs." . \Illuminate\Support\Arr::get($docs, "bs", "0"));
            $ubFile = data_get($docFiles, "ub." . \Illuminate\Support\Arr::get($docs, "ub", "0"));
            if ($both) {
                if (!$bsFile && !$ubFile) {
                    throw \Illuminate\Validation\ValidationException::withMessages(["error" => __("Upload both bank statement or utility bill.")]);
                }
                if (!$bsFile) {
                    throw \Illuminate\Validation\ValidationException::withMessages(["error" => __("Please upload the :document.", ["document" => __($bsdoc)])]);
                }
                if (!$ubFile) {
                    throw \Illuminate\Validation\ValidationException::withMessages(["error" => __("Please upload the :document.", ["document" => __($ubdoc)])]);
                }
            }
            if ($bs && $ub && !$both && !$bsFile && !$ubFile) {
                throw \Illuminate\Validation\ValidationException::withMessages(["error" => __("Upload either bank statement or utility bill.")]);
            }
            if ($bs && !$ub && !$bsFile) {
                throw \Illuminate\Validation\ValidationException::withMessages(["error" => __("Please upload the :document.", ["document" => __($bsdoc)])]);
            }
            if ($ub && !$bs && !$ubFile) {
                throw \Illuminate\Validation\ValidationException::withMessages(["error" => __("Please upload the :document.", ["document" => __($ubdoc)])]);
            }
            if (\NioModules\BasicKYC\BasicKYCModule::isInvalid()) {
                throw \Illuminate\Validation\ValidationException::withMessages(["invalid" => __("We are temporarily unable to process your request. Please try again later.")]);
            }
            try {
                return $this->wrapInTransaction(function ($docs, $docFiles, $getSession) {
                    if (!empty($docs) && is_array($docs)) {
                        $bs_ub = [];
                        $isBs = $isUb = false;
                        foreach ($docs as $key => $hash) {
                            $file = data_get($docFiles, $key . "." . $hash);
                            if (!empty($file) && \Illuminate\Support\Facades\Storage::exists($this->pathTemp . "/" . $file)) {
                                $proofDoc = $getSession->document($key);
                                $this->addOrUpdateProofDoc($proofDoc, $key, $file, $getSession);
                                if ($key == "bs") {
                                    $isBs = true;
                                }
                                if ($key == "ub") {
                                    $isUb = true;
                                }
                            }
                        }
                        if ($isBs) {
                            $bs_ub[] = "bs";
                        }
                        if ($isUb) {
                            $bs_ub[] = "ub";
                        }
                        if (!empty($bs_ub)) {
                            $getSession->docs = array_merge(data_get($getSession, "docs", []), ["proof" => $bs_ub]);
                            $getSession->save();
                        } else {
                            $getSession->docs = array_merge(data_get($getSession, "docs", []), ["proof" => []]);
                            $getSession->save();
                        }
                    }
                    \Illuminate\Support\Facades\Session::put("proof_files", []);
                    return $this->finalPreview();
                }, $docs, $docFiles, $getSession);
            } catch (\Exception $e) {
                save_error_log($e);
                throw \Illuminate\Validation\ValidationException::withMessages(["warning" => __("Something went wrong. Please reload the page and try again.")]);
            }
        } else {
            throw \Illuminate\Validation\ValidationException::withMessages(["warning" => __("Something went wrong. Please reload the page and try again.")]);
        }
    }
    private function addOrUpdateProofDoc($proof, $key, $file, $session)
    {
        if (!empty($key) && !empty($file)) {
            if (!blank($proof)) {
                $files = data_get($proof, "files", []);
                $this->removeExistFiles($files);
                $proof->type = $key;
                $proof->files = ["main" => $file];
                $proof->save();
            } else {
                $kycDoc = new \NioModules\BasicKYC\Models\KycDocs();
                $kycDoc->session_id = $session->id;
                $kycDoc->user_id = $session->user_id;
                $kycDoc->type = $key;
                $kycDoc->files = ["main" => $file];
                $kycDoc->save();
            }
        }
    }
    public function handleFiles(\Illuminate\Http\Request $request)
    {
        $input = $request->validate(["doc" => "required|in:main,front,back,proof,bs,ub", "action" => "in:store,delete", "document" => "file|mimetypes:image/jpg,image/png,image/jpeg|max:5200"], ["doc.*" => __("Invalid action taken."), "action.in" => __("Invalid action taken."), "document.max" => __("File exceeds the maximum upload file size of 5 MB."), "document.file" => __("Please select a valid file type and try once again."), "document.mimetypes" => __("Invalid file type, only JPG and PNG files are allowed."), "document.uploaded" => __("Unable to upload file due to technical issues.")]);
        $uploaded = in_array($input["doc"], ["bs", "ub"]) ? "proof_files" : "main_files";
        $paths = \Illuminate\Support\Facades\Session::get($uploaded, []);
        if ($input["action"] == "store") {
            try {
                $file = $request->document;
                $docType = $request->doc;
                if (empty($file) || empty($docType) || !in_array($docType, $this->docKeys)) {
                    return response()->json(["error" => 81405, "message" => __("Invalid action taken.")]);
                }
                $hash = cipher(now()->timestamp);
                $exten = strtolower($file->getClientOriginalExtension());
                $name = auth()->id() . "_" . $docType . "_" . $hash . "." . $exten;
                $paths[$docType][$hash] = $name;
                $file->storeAs($this->pathTemp, $name);
                \Illuminate\Support\Facades\Session::put($uploaded, $paths);
                return response()->json(["message" => __("File has been uploaded."), "hash" => $hash]);
            } catch (\Exception $e) {
                save_msg_log($e->getMessage(), "info");
                return response()->json(["error" => 81402, "message" => __("Unable to upload file.")]);
            }
        }
        if ($input["action"] == "delete") {
            if (empty($request->doc) || empty($request->hash) || !in_array($request->doc, $this->docKeys)) {
                return response()->json(["error" => 82405, "message" => __("Invalid action taken.")]);
            }
            try {
                if (!empty($paths[$request->doc][$request->hash])) {
                    $pathFile = $this->pathTemp . "/" . $paths[$request->doc][$request->hash];
                    if (\Illuminate\Support\Facades\Storage::exists($pathFile)) {
                        \Illuminate\Support\Facades\Storage::delete($pathFile);
                    }
                    unset($paths[$request->doc]);
                    return response()->json(["message" => __("File has been removed."), "hash" => $request->hash]);
                }
                return response()->json(["error" => 82401, "message" => __("Unable to remove file.")]);
            } catch (\Exception $e) {
                save_msg_log($e->getMessage(), "info");
                return response()->json(["error" => 82402, "message" => __("Unable to remove file.")]);
            }
        }
        return response()->json(["error" => true, "message" => __("Unknown Error")]);
    }
    public function removeOldFile($file)
    {
        $fullpath = $this->pathTemp . "/" . $file;
        if (!empty($file) && \Illuminate\Support\Facades\Storage::exists($fullpath)) {
            \Illuminate\Support\Facades\Storage::delete($fullpath);
        }
    }
    private function removeExistFiles(array $files)
    {
        if (!empty($files)) {
            try {
                foreach ($files as $key => $file) {
                    $this->removeOldFile($file);
                }
            } catch (\Exception $e) {
            }
        }
    }
    private function moveFiles(array $files)
    {
        if (!empty($files)) {
            foreach ($files as $key => $file) {
                $tempPath = $this->pathTemp . "/" . $file;
                $savePath = $this->pathSave . "/" . $file;
                if (\Illuminate\Support\Facades\Storage::exists($tempPath)) {
                    if (\Illuminate\Support\Facades\Storage::exists($savePath)) {
                        \Illuminate\Support\Facades\Storage::delete($savePath);
                    }
                    \Illuminate\Support\Facades\Storage::copy($tempPath, $savePath);
                }
            }
        }
    }
    private function moveSubmittedFiles($session)
    {
        if (!blank($session)) {
            $mainDoc = $session->document("main");
            $this->moveFiles(data_get($mainDoc, "files", []));
            $proof = data_get($session, "docs.proof", []);
            if (!empty($proof)) {
                $bsDoc = $session->document("bs");
                if (!blank($bsDoc)) {
                    $bsFiles = data_get($bsDoc, "files", []);
                    if (in_array("bs", $proof)) {
                        $this->moveFiles($bsFiles);
                    } else {
                        $this->removeExistFiles($bsFiles);
                        $bsDoc->files = [];
                        $bsDoc->state = \NioModules\BasicKYC\Helpers\KycDocStatus::INVALID;
                        $bsDoc->save();
                    }
                }
                $ubDoc = $session->document("ub");
                if (!blank($ubDoc)) {
                    $ubFiles = data_get($ubDoc, "files", []);
                    if (in_array("ub", $proof)) {
                        $this->moveFiles($ubFiles);
                    } else {
                        $this->removeExistFiles($ubFiles);
                        $ubDoc->files = [];
                        $ubDoc->state = \NioModules\BasicKYC\Helpers\KycDocStatus::INVALID;
                        $ubDoc->save();
                    }
                }
            }
        }
    }
    private function removeSubmittedFiles($session)
    {
        if (!blank($session)) {
            try {
                $this->wrapInTransaction(function ($session) {
                    $session->docs = [];
                    $session->save();
                    $mainDoc = $session->document("main");
                    $mainFiles = data_get($mainDoc, "files", []);
                    if (!blank($mainDoc)) {
                        $this->removeExistFiles($mainFiles);
                        $mainDoc->files = [];
                        $mainDoc->meta = [];
                        $mainDoc->save();
                    }
                    $bsDoc = $session->document("bs");
                    $bsFiles = data_get($bsDoc, "files", []);
                    if (!blank($bsDoc)) {
                        $this->removeExistFiles($bsFiles);
                        $bsDoc->files = [];
                        $bsDoc->save();
                    }
                    $ubDoc = $session->document("ub");
                    $ubFiles = data_get($ubDoc, "files", []);
                    if (!blank($ubDoc)) {
                        $this->removeExistFiles($ubFiles);
                        $ubDoc->files = [];
                        $ubDoc->save();
                    }
                }, $session);
            } catch (\Exception $e) {
            }
        }
    }
    private function docsAlter($key = NULL)
    {
        $altdoc = data_get(gss("kyc_docs"), "alter");
        $options = ["opt" => false, "req" => false, "bs" => false, "ub" => false, "check" => false];
        if (!empty($altdoc) && is_array($altdoc)) {
            $ub = array_key_exists("ub", $altdoc);
            $bs = array_key_exists("bs", $altdoc);
            $req = array_key_exists("required", $altdoc) && $ub && $bs;
            $options = ["opt" => $bs || $ub ? true : false, "req" => $req, "bs" => $bs, "ub" => $ub];
        }
        if (!empty($key)) {
            return isset($options[$key]) ? $options[$key] : NULL;
        }
        return $options;
    }
    private function docsMain($key = NULL)
    {
        $setting = data_get(gss("kyc_docs"), "main");
        $options = ["opt" => false, "pp" => false, "nid" => false, "dvl" => false, "proof" => false];
        if (!empty($setting) && is_array($setting)) {
            $pp = array_key_exists("pp", $setting);
            $nid = array_key_exists("nid", $setting);
            $dvl = array_key_exists("dvl", $setting);
            $proof = gss("kyc_doc_selfie", "no") == "yes" ? true : false;
            $options = ["opt" => $pp || $nid || $dvl ? true : false, "pp" => $pp, "nid" => $nid, "dvl" => $dvl, "proof" => $proof];
        }
        if (!empty($key)) {
            return isset($options[$key]) ? $options[$key] : NULL;
        }
        return $options;
    }
    private function fileCleanup($session, $clean = NULL)
    {
        if (!blank($session)) {
            if ($clean == "document") {
                $uploaded = "main_files";
            } else if ($clean == "additional") {
                $uploaded = "proof_files";
            } else {
                $uploaded = "uploaded_files";
            }
            $mainFiles = \Illuminate\Support\Facades\Session::get($uploaded, []);
            if (!empty($mainFiles)) {
                foreach ($mainFiles as $key => $val) {
                    $file = array_values($val);
                    if (!empty($file[0])) {
                        if ($clean == "document") {
                            $mainDocs = $session->document("main");
                            $oldFiles = data_get($mainDocs, "files", []);
                            if (blank($mainDocs) || empty($oldFiles)) {
                                $this->removeOldFile($file[0]);
                            }
                            if (!empty($oldFiles[$key]) && $oldFiles[$key] != $file[0]) {
                                $this->removeOldFile($file[0]);
                            }
                        } else if ($clean == "additional") {
                            $bsDocs = $session->document("bs");
                            $bsFiles = data_get($bsDocs, "files", []);
                            if (blank($bsDocs) || empty($bsFiles)) {
                                $this->removeOldFile($file[0]);
                            }
                            if (!empty($bsFiles[$key]) && $bsFiles[$key] != $file[0]) {
                                $this->removeOldFile($file[0]);
                            }
                            $ubDocs = $session->document("ub");
                            $ubFiles = data_get($ubDocs, "files", []);
                            if (blank($ubDocs) || empty($ubFiles)) {
                                $this->removeOldFile($file[0]);
                            }
                            if (!empty($ubFiles[$key]) && $ubFiles[$key] != $file[0]) {
                                $this->removeOldFile($file[0]);
                            }
                        }
                    }
                }
            }
        }
    }
    private function isInvalidFile($file)
    {
        if (!empty($file)) {
            $extension = explode(".", $file);
            if (str_contains($file, "/") || empty($extension[1])) {
                return true;
            }
            if (!in_array($extension[1], ["jpg", "jpeg", "png"])) {
                return true;
            }
            return false;
        }
        return false;
    }
    private function hasDocsFiles($document)
    {
        if (blank($document) || !data_get($document, "files", [])) {
            return false;
        }
        return true;
    }
    private function addNewApplicant()
    {
        $userId = auth()->user()->id;
        $reference = $this->kycModule->generateReference();
        $kycApplicant = new \NioModules\BasicKYC\Models\KycApplicants();
        $kycApplicant->user_id = $userId;
        $kycApplicant->reference = $reference;
        $kycApplicant->status = \NioModules\BasicKYC\Helpers\KycStatus::STARTED;
        $kycApplicant->save();
        return $kycApplicant->fresh();
    }
    private function addNewSession($profile)
    {
        $userId = auth()->user()->id;
        $sessionId = $this->kycModule->generateUniqueSession();
        $newSession = new \NioModules\BasicKYC\Models\KycSessions();
        $newSession->user_id = $userId;
        $newSession->session = $sessionId;
        $newSession->profile = $profile;
        $newSession->method = "manual";
        $newSession->status = \NioModules\BasicKYC\Helpers\KycSessionStatus::STARTED;
        $newSession->save();
        return $newSession->fresh();
    }
}

?>