<?php
#This Code is Cracked by dharunMods-YouTube-Channel

namespace NioModules\BasicKYC\Controllers;

use App\Http\Controllers\Controller;
use App\Traits\WrapInTransaction;
use Illuminate\Http\Request;
//use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Validation\ValidationException;
use NioModules\BasicKYC\BasicKYCModule;
use NioModules\BasicKYC\Helpers\ImportSettings;
use Illuminate\Support\Str;
use App\Models\Setting;

class KycSettingsController extends Controller
{
    private $module;
    private $pathTemp = "kyc-temp";
    private $pathSave = "kyc";

    public function __construct(BasicKYCModule $module)
    {
        $this->module = $module;
    }

    public function index()
    {
       //Log::info("Accessing KYC settings index page.");

        $getFields = BasicKYCModule::getFields();
        $mainDocs = data_get($getFields, "docs.main");
        $additionalDocs = data_get($getFields, "docs.additional");
        $profileFields = data_get($getFields, "profile");

        $activate = $this->module->moduleActivate();
        $compatibility = $this->module->compatible();
        $outdated = $compatibility ? false : $this->module->minAppVer();

       //Log::info("KYC module compatibility: " . json_encode($compatibility));
       //Log::info("KYC module version status: " . json_encode($outdated));

        if ($compatibility) {
            $imported = new ImportSettings();
            $version = $imported->vers();
            $updated = hss("mod_kyc_update", NULL);
            if (empty($updated) || $updated < $version) {
               //Log::info("Running KYC import initialization for version: " . $version);
                $imported->initialize();
                upss("mod_kyc_update", $version);
            }
        }

        return view("BasicKYC::admin.settings", compact("profileFields", "mainDocs", "additionalDocs", "compatibility", "outdated"));
    }

    private function validateSettings(Request $request)
    {
        if (filled($formType = $request->get("form_type"))) {
            $method = "validate" . Str::studly($formType);
            if (method_exists($this, $method)) {
               //Log::info("Calling validation method: " . $method);
                return $this->{$method}($request);
            }
        }

       //Log::error("Invalid form_type in KYC settings validation.");
        throw ValidationException::withMessages([__("Unable to perform this action!")]);
    }

    private function validateKycSettings($request)
    {
        return $request->validate([
            "feature_enable" => "required|in:yes,no",
            "verification" => "required|in:yes,no",
            "verified" => "nullable|array",
            "profile_locked" => "required|in:yes,no",
            "profile_complete" => "required|in:yes,no",
            "disable_request" => "required|in:yes,no",
            "disable_title" => "nullable",
            "disable_notice" => "nullable"
        ]);
    }

    private function validateKycFormSettings($request)
    {
        return $request->validate([
            "preview_quick" => "required|in:yes,no",
            "fields" => "nullable|array",
            "docs" => "array",
            "docs.main" => "required|array",
            "doc_selfie" => "required|in:yes,no"
        ], [
            "docs.main.required" => __("Please select at least one document for verification purpose.")
        ]);
    }

    public function saveSettings(Request $request)
    {
       //Log::info("KYC settings save initiated.");

        try {
            if (!Storage::exists($this->pathTemp)) {
               //Log::info("Creating temp directory: " . $this->pathTemp);
                Storage::makeDirectory($this->pathTemp);
            }

            if (!Storage::exists($this->pathSave)) {
               //Log::info("Creating save directory: " . $this->pathSave);
                Storage::makeDirectory($this->pathSave);
            }

            $settings = $this->validateSettings($request);
           //Log::info("Validated settings: ", $settings);

            if (isset($settings["feature_enable"])) {
                $settings["feature_enable"] = $settings["feature_enable"] == "yes" && $this->module->validateState($settings) ? "yes" : "no";
            } else {
                $settings["feature_enable"] = gss("kyc_feature_enable", "no") == "yes" && $this->module->validateState($settings) ? "yes" : "no";
            }

            if ($this->module->validateState($settings) && !$this->module->moduleState()) {
                $cookie_key = "_mse_BK" . strtoupper(ghp(true));
                $queue = (int) gss("dw_cancel_timeout", 1);
                $queue = $queue < 0 ? 5 : $queue;

                if (!$request->hasCookie($cookie_key) || !$this->module->moduleState(false)) {
                    $state = $this->module->moduleActivate(true);
                    if ($state) {
                        Cookie::queue(Cookie::forget($cookie_key));
                    } else {
                        Cookie::queue(Cookie::make($cookie_key, "accept", 60 * $queue));
                        $settings["feature_enable"] = "no";
                    }
                }
            }

            $this->wrapInTransaction(function () use ($settings) {
                foreach ($settings as $key => $value) {
                    $prefixedKey = "kyc_" . $key;
                    $value = is_array($value) ? json_encode($value) : $value;
                    Setting::updateOrCreate(["key" => $prefixedKey], ["value" => $value]);
                   //Log::info("Saved setting: {$prefixedKey} => " . print_r($value, true));
                }
            });

           //Log::info("KYC settings saved successfully.");
            return response()->json(["msg" => __("Basic KYC Settings successfully updated.")]);

        } catch (ValidationException $e) {
           //Log::error("Validation error during KYC settings save: " . $e->getMessage());
            throw $e;
        } catch (\Exception $e) {
           //Log::error("Exception in saving KYC settings: " . $e->getMessage());
            throw ValidationException::withMessages([
                "kyc" => __("Unable to proceed. Please check your storage folder permission.")
            ]);
        }
    }
}
