<?php
namespace NioModules\BasicKYC;

class BasicKYCModule
{
    private $bySlug = NULL;

    const VERSION = "1.0.1";
    const LAST_UPDATE = "01142022";
    const MIN_APP_VER = "1.2.0";
    const MOD_TYPES = "module";
    const SLUG = "basic-kyc";
    const METHOD = "manual";

    public function __construct()
    {
        $this->bySlug = str_replace("-", "_", self::SLUG);
    }

    public function minAppVer()
    {
        return self::MIN_APP_VER;
    }

    public function getVer()
    {
        return self::VERSION;
    }

    public function getSlug()
    {
        return self::SLUG;
    }

    public function compatible()
    {
        return true; // Always compatible
    }

    public function validateState($input)
    {
        return true; // Always valid
    }

    public function moduleState($bool = true)
    {
        return true; // Always active
    }

    public function moduleActivate($force = false)
    {
        return true; // Always activated
    }

    public function checkActivation($force = false)
    {
        return 10; // Always valid
    }

    public function checkOnTime($day = 3)
    {
        return true; // Skip check schedule
    }

    public function messages($key, $type)
    {
        $messages = base_path(implode(DIRECTORY_SEPARATOR, ["niomodules", "BasicKYC", "Config", "messages.php"]));
        if (!file_exists($messages)) {
            return false;
        }
        $messages = collect(include $messages);
        return $messages->get($type)[$key] ?? false;
    }

    public function alert($attr = [])
    {
        if (feature_enable("kyc") && gss("kyc_verification") == "yes" && !auth()->user()->kyc_verified && !auth()->user()->kyc_rejected && auth()->user()->is_verified) {
            $getKycApplicant = Models\KycApplicants::where("user_id", auth()->user()->id)->first();
            if (data_get($getKycApplicant, "status") == Helpers\KycStatus::RESUBMIT) {
                $message = __("Please resubmit your all the valid documents to verify your identity.");
                $attr["type"] = "info";
            } else {
                if (!data_get($getKycApplicant, "status") || data_get($getKycApplicant, "status") == Helpers\KycStatus::STARTED) {
                    $attr["type"] = "primary";
                    $message = __("To be compliant and to protect your account, please verify your identity by submitting document.");
                }
            }
            return view("BasicKYC::user.misc.alert", compact("message", "attr", "getKycApplicant"))->render();
        }
        return false;
    }

    public static function getFields($type = NULL)
    {
        $allFields = ["profile" => ["name" => ["label" => __("Full Name"), "default" => ["show" => true, "required" => true, "disabled" => true]], "dob" => ["label" => __("Date of Birth"), "default" => ["show" => true, "required" => true]], "phone" => ["label" => __("Phone Number"), "default" => ["show" => false, "required" => false]], "gender" => ["label" => __("Gender"), "default" => ["show" => false, "required" => false]], "nationality" => ["label" => __("Nationality"), "default" => ["show" => true, "required" => false]], "country" => ["label" => __("Country"), "default" => ["show" => true, "required" => true, "disabled" => true]], "address" => ["label" => __("Address"), "default" => ["show" => true, "required" => false]]], "docs" => ["main" => ["pp" => ["label" => __("Passport"), "default" => ["show" => true], "note" => __("Allow passport for user identity verification."), "files" => ["main"]], "nid" => ["label" => __("National ID"), "default" => ["show" => true], "note" => __("Allow national ID for user identity verification."), "files" => ["main", "back"]], "dvl" => ["label" => __("Driving License"), "default" => ["show" => false], "note" => __("Allow driving license for user identity verification."), "files" => ["main", "back"]]], "additional" => ["bs" => ["label" => __("Bank Statement"), "default" => ["show" => true, "required" => true], "note" => __("Allow bank statements for additional verification."), "files" => ["main"]], "ub" => ["label" => __("Utility Bill"), "default" => ["show" => false, "required" => false], "note" => __("Allow utility bill for additional verification."), "files" => ["main"]]]]];
        if (!empty($type)) {
            return isset($allFields[$type]) ? $allFields[$type] : [];
        }
        return $allFields;
    }

    public function generateReference()
    {
        $latest = Models\KycApplicants::orderBy("id", "desc")->latest()->first();
        $nextid = isset($latest->id) ? sprintf("%03s", $latest->id + 1) : sprintf("%03s", 1);
        $reference = (int) (mt_rand(10, 99) . substr(time(), -3) . $nextid);
        $existing = Models\KycApplicants::where("reference", $reference)->first();
        if (blank($existing)) {
            return $reference;
        }
        return $this->generateReference();
    }

    public function generateUniqueSession()
    {
        $userId = auth()->user()->id;
        $count = Models\KycSessions::where("user_id", $userId)->count();
        $nextid = $count ? sprintf("%04s", $count + 1) : sprintf("%04s", 1);
        $session = cipher($userId) . "-" . substr(time(), -8) . "-" . $nextid;
        $existing = Models\KycSessions::where("session", $session)->first();
        if (blank($existing)) {
            return $session;
        }
        return $this->generateUniqueSession();
    }

    public function updateAppSystem($force = false, $session = true)
    {
        return false; // Skip updating system
    }

    public static function isInvalid()
    {
        return false; // Always valid
    }
}
?>
