<?php

namespace App\Updates;

use App\Enums\EmailRecipientType;
use App\Enums\EmailTemplateStatus;
use App\Models\EmailTemplate;

class MigrationVer2411151 implements UpdaterInterface
{
    const VERSION = 2411151;

    public function getVersion()
    {
        return self::VERSION;
    }

    public function handle()
    {
        $this->addEmailTemplates();
    }

    private function addEmailTemplates()
    {
        $templates = [
            'users-admin-reset-2fa' => [
                'name' => '2FA Disable by Admin',
                'slug' => 'users-admin-reset-2fa',
                'group' => 'authentication',
                'recipient' => EmailRecipientType::CUSTOMER,
                'status' => EmailTemplateStatus::ACTIVE,
                'params' => ["regards" => "on"],
                'subject' => 'Disable 2FA Authentication Request',
                'greeting' => 'Hi [[user_name]],',
                'content' => "We have reset your 2FA authentication as per your requested via support.\n\n If you really want to reset 2FA authentication security in your account, then click the button below to confirm and reset 2FA authentication on your account.",
                'shortcut' => '',
            ],
        ];

        foreach ($templates as $slug => $template) {
            $exist = EmailTemplate::where('slug', $slug)->count();
            if ($exist == 0) {
                EmailTemplate::create($template);
            }
        }
    }
}
